<?PHP if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class GroupsModel extends CI_Model {
	
    function __construct() {
        parent::__construct();
		
    }
	public function create_group ($ou,$cn,$description){
		$ldap_conn = $this->prepare_ldap_conn();
		$ldap_bind = ldap_bind($ldap_conn, LDAP_ANON_ADMIN_USERNAME, LDAP_ANON_ADMIN_PASSWORD);
		if($ldap_bind) {
			$attributes = array(
				'ou' => $ou,
				'cn' => $cn,
				'description' => $description,
				'member' => array("cn=admin,".LDAP_BASE_RDN),
				'mail' => $ou."@".DIRECT_DOMAIN,
				'objectClass' => array("extensibleObject","groupOfNames","top")
			);
				if(ldap_add($ldap_conn, $this->get_dn_from_groupname($ou),$attributes)){
					return TRUE;
				}
				else{
					return FALSE;
				}
		}
		else{ return FALSE;}
	}
	public function disable_group($group){
		$dn = $this->get_dn_from_groupname($group);
		$ldap_conn = $this->prepare_ldap_conn();
		//TO-DO: $ldap_bind = $this->ldap_bind_current_user($ldap_conn); //logged in user must have privileges to disable
		$ldap_bind = ldap_bind($ldap_conn, LDAP_ANON_ADMIN_USERNAME, LDAP_ANON_ADMIN_PASSWORD);
		if($ldap_bind) {
			return ldap_rename($ldap_conn, $dn,'ou=' . $group,LDAP_DISABLED_GROUPS_GROUP, TRUE);
		}
		return false;
	}
	public function enable_group($group){
		$dn = $this->get_disabled_dn_from_groupname($group);
		$ldap_conn = $this->prepare_ldap_conn();
		//TO-DO: $ldap_bind = $this->ldap_bind_current_user($ldap_conn); //logged in user must have privileges to disable
		$ldap_bind = ldap_bind($ldap_conn, LDAP_ANON_ADMIN_USERNAME, LDAP_ANON_ADMIN_PASSWORD);
		if($ldap_bind) {
			return ldap_rename($ldap_conn, $dn,'ou=' . $group,LDAP_GROUPS_GROUP, TRUE);
		}
		return false;
	}
		/* Simple function to format a dn for a given groupname on this system
	 * abstracted to a function so that it can be changed in only
	 * one place if the format ever changes.
	 */ 
	public function get_dn_from_groupname($username) {
		return 'ou='.$username.','.LDAP_GROUPS_GROUP;
	}
	/* Similar to get dn, but gets the dn as if the group were disabled */
	public function get_disabled_dn_from_groupname($username) {
		return 'ou='.$username.','.LDAP_DISABLED_GROUPS_GROUP;
	}
	public function get_group_from_groupname($group,$active = TRUE){
		$ldap_conn = $this->prepare_ldap_conn();
    	$ldap_bind = ldap_bind($ldap_conn, LDAP_ANON_SEARCH_USERNAME, LDAP_ANON_SEARCH_PASSWORD);
		if($ldap_bind) {
			$fields = array('ou','cn','description','mail','members');
			$base_dn = LDAP_GROUPS_GROUP;
			if(!$active) { $base_dn = LDAP_DISABLED_GROUPS_GROUP; }
			$search = ldap_search($ldap_conn, $base_dn, '(&(ou='.$group.')(cn=*))', $fields);
			$entries = ldap_get_entries($ldap_conn, $search);
			$groups = array();
			for($i = 0; $i < $entries['count']; $i++) {
				$entry = $entries[$i];
				$group = array();
				foreach($fields as $key) {
					if($key !== 'count' && isset($entry[$key][0])) { $group[$key] = $entry[$key][0];} 
				}
				$group['access'] = $this->get_access($group['ou']);
				array_push($groups,$group);
				
			}
			return $groups;
		}
		return false;
	}
	public function get_disabled_groups(){
		return $this->get_group_from_groupname("*",FALSE);
	}
	
	public function get_disabled_groups_by_page_number($start, $size) {
		$groups_by_page_number = array();
		$groups = $this->get_disabled_groups();
		$j = 0;
		for($i = 0; $i < sizeOf($groups); $i++) {
	
			if($i >= $start - 1 && $i < $start - 1 + $size) {
				$groups_by_page_number[$j] = $groups[$i];
				$j++;
			}
		}
		return $groups_by_page_number;
	}
	
	public function get_groups(){
		return $this->get_group_from_groupname("*",TRUE);
	}
	
	public function get_groups_by_page_number($start, $size) {
		$groups_by_page_number = array();
		$groups = $this->get_groups();
		$j = 0;
		for($i = 0; $i < sizeOf($groups); $i++) {
				
			if($i >= $start - 1 && $i < $start - 1 + $size) {
				$groups_by_page_number[$j] = $groups[$i];
				$j++;
			}
		}
		return $groups_by_page_number;
	}
	
	public function get_access($group) {
		
		$dn = $this->get_dn_from_groupname($group);
		$ldap_conn = $this->prepare_ldap_conn();
		$ldap_bind = ldap_bind($ldap_conn, LDAP_ANON_SEARCH_USERNAME, LDAP_ANON_SEARCH_PASSWORD);
		if($ldap_bind) {
			$search = ldap_search($ldap_conn, LDAP_BASE_RDN, '(&(member='.$dn.'))', array('cn'));
			$entries = ldap_get_entries($ldap_conn, $search);
			$groups = array();
			for($i = 0; $i < $entries['count']; $i++) { array_push($groups,$entries[$i]['cn'][0]); }
			return $groups;
		}
		
		return FALSE;
	}
	public function group_exist($group) {
		$ldap_conn = $this->prepare_ldap_conn();
		$ldap_bind = ldap_bind($ldap_conn, LDAP_ANON_SEARCH_USERNAME, LDAP_ANON_SEARCH_PASSWORD);
		if($ldap_bind) {
			$search = ldap_search($ldap_conn, LDAP_GROUPS_GROUP, '(&(ou=' . $group . ')(cn=*))', array('ou'));
			$entries = ldap_get_entries($ldap_conn, $search);
			if($entries['count'] !== 0) { return TRUE; }
			else{
				$search = ldap_search($ldap_conn, LDAP_DISABLED_GROUPS_GROUP, '(&(ou=' . $group . ')(cn=*))', array('ou'));
				$entries = ldap_get_entries($ldap_conn, $search);
				if($entries['count'] !== 0) { return TRUE; }
				else{return FALSE;}
			}
		}
		else { return NULL; }
	}
	public function change_group_membership($action, $group_name, $group_cn) {
		if($action !== 'add' && $action !== 'remove') { return FALSE; }
		
		$user_dn = $this->get_dn_from_groupname($group_name); //even disabled users are stored in groups as their non-disabled dn
		
		$ldap_conn = $this->prepare_ldap_conn();
		//because this potentially will be exposed as an API function, we cannot get client cert to link to a user account
		//so use anonymous LDAP admin account and log that the request came from this application
		$ldap_bind = ldap_bind($ldap_conn, LDAP_ANON_ADMIN_USERNAME, LDAP_ANON_ADMIN_PASSWORD);
		if($ldap_bind) {
			$search = ldap_search($ldap_conn, LDAP_BASE_RDN, '(&(cn='.$group_cn.')(objectClass=groupOfNames))', array('dn'));
    		$entries = ldap_get_entries($ldap_conn, $search);
			if($entries['count'] === 1) { //has to be just one entry or it can't be sure what to remove
				$group_dn = $entries[0]['dn'];
				if($action === 'remove') { 
					$remove = @ldap_mod_del($ldap_conn,$group_dn,array('member'=>$user_dn));
					//if the attribute didn't exist before (error 16), then we didn't need to get rid of it and therefore we did what we wanted
					if(!$remove && ldap_errno($ldap_conn) === 16) { return TRUE; }
					else { return $remove; }
				}
				if($action === 'add') { 
					return ldap_mod_add($ldap_conn,$group_dn,array('member'=>$user_dn));
				}
			}
		}
		return FALSE;
	}
	public function get_allowed_groups_for_access($permissions) {
		$ldap_conn = $this->prepare_ldap_conn();
		$ldap_bind = ldap_bind($ldap_conn, LDAP_ANON_SEARCH_USERNAME, LDAP_ANON_SEARCH_PASSWORD);
		if($ldap_bind) {
			//if the user is part of the API admins group, return all groups
			if($permissions['API']['admins']) {
				$search = ldap_search($ldap_conn, LDAP_BASE_RDN, '(objectClass=groupOfNames)', array('dn','cn','ou'));
				$entries = ldap_get_entries($ldap_conn, $search);
				$result = array();
				foreach($entries as $key => $entry) {
					//don't include count array entry, and don't show groups that are for application entries only
					if(is_numeric($key) && $entry['dn'] !== LDAP_DIRECT_API_PERMISSIONS_GROUP && $entry['dn'] !== LDAP_ADMIN_API_PERMISSIONS_GROUP && $entry['ou'][0] === "users") { 
						array_push($result,$entry['cn'][0]); 
					}
				}
				return $result;
			}
			//TO-DO: for now, everyone else gets nothing, this will need to change
			return array();
		}
		return FALSE;
	}
	public function update_group($group_name, $display_name, $description) {
		if($group_name) {
			$ldap_conn = $this->prepare_ldap_conn();
			//because this potentially will be exposed as an API function, we cannot get client cert to link to a user account
			//so use anonymous LDAP admin account and log that the request came from this application
			$ldap_bind = ldap_bind($ldap_conn, LDAP_ANON_ADMIN_USERNAME, LDAP_ANON_ADMIN_PASSWORD);
			if($ldap_bind) {
				if(count($this->get_group_from_groupname($group_name)) === 1){//check if group is deleted
					$group_dn = $this->get_dn_from_groupname($group_name); 
				}
				else { 
					$group_dn = $this->get_disabled_dn_from_groupname($group_name);
				}
				$attribute_arr = array(
					'description' => $description,
					'cn' => $display_name
				);
				return ldap_modify($ldap_conn,$group_dn,$attribute_arr);
			}
		}
		return FALSE;
	}
	public function get_group_dn_from_direct_address($address){
		$ldap_conn = $this->prepare_ldap_conn();
		$ldap_bind = ldap_bind($ldap_conn, LDAP_ANON_SEARCH_USERNAME, LDAP_ANON_SEARCH_PASSWORD);
		if($ldap_bind) {
			//search for groups that this user is in
			$search = ldap_search($ldap_conn, LDAP_GROUPS_GROUP, '(&(mail=' . $address . '))', array('dn'));
			$entries = ldap_get_entries($ldap_conn, $search);
			if($entries['count'] === 0 || $entries['count'] > 1) { return FALSE; } //if no entries, or too many entries
			return ($entries[0]['dn']);
		}
		return FALSE;
	}
	public function get_group_address_permissions_for_app_dn($address,$app_dn){
		$group_dn = $this->get_group_dn_from_direct_address($address);
		if($group_dn){
			$ldap_conn = $this->prepare_ldap_conn();
			$ldap_bind = ldap_bind($ldap_conn, LDAP_ANON_SEARCH_USERNAME, LDAP_ANON_SEARCH_PASSWORD);
			if($ldap_bind) {
				$search = ldap_search($ldap_conn, $app_dn, '(&(member=' . $group_dn . '))', array('dn'));
				$entries = ldap_get_entries($ldap_conn, $search);
				if($entries['count'] === 0 || $entries['count'] > 1) { return FALSE; }
				else{
					return  array('send'=>TRUE);
				}
			}
		}	
		return false;
		
	}
	/* -----------------------------*
	 *  PRIVATE FUNCTIONS           *
	 * -----------------------------*/
	
	private function prepare_ldap_conn() {
		$ldap_conn = ldap_connect(LDAP_HOSTNAME, LDAP_PORT);
		if(!ldap_set_option($ldap_conn, LDAP_OPT_PROTOCOL_VERSION, 3)) { return FALSE; } 
		if(!ldap_set_option($ldap_conn, LDAP_OPT_REFERRALS, 0)) { return FALSE; }
		return $ldap_conn;
	}
}